/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.html.renderer;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.html.renderer.LinkStatus;
import icyllis.flexmark.html.renderer.ResolvedLink;
import java.util.Arrays;

public class ResolvedContent {
    @NotNull
    private final ResolvedLink resolvedLink;
    @NotNull
    private final LinkStatus status;
    @Nullable
    private final byte[] content;

    public ResolvedContent(@NotNull ResolvedLink resolvedLink, @NotNull LinkStatus status, @Nullable byte[] content) {
        this.resolvedLink = resolvedLink;
        this.status = status;
        this.content = content;
    }

    public ResolvedContent withStatus(@NotNull LinkStatus status) {
        return status == this.status ? this : new ResolvedContent(this.resolvedLink, status, this.content);
    }

    public ResolvedContent withContent(@Nullable byte[] content) {
        return Arrays.equals(this.content, content) ? this : new ResolvedContent(this.resolvedLink, this.status, content);
    }

    @NotNull
    public ResolvedLink getResolvedLink() {
        return this.resolvedLink;
    }

    @NotNull
    public LinkStatus getStatus() {
        return this.status;
    }

    @Nullable
    public byte[] getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedContent content1 = (ResolvedContent)o;
        if (!this.resolvedLink.equals(content1.resolvedLink)) {
            return false;
        }
        if (!this.status.equals(content1.status)) {
            return false;
        }
        return Arrays.equals(this.content, content1.content);
    }

    public int hashCode() {
        int result = this.resolvedLink.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

